Attribute VB_Name = "Module1"
Option Explicit

Global ToggleRLY1%, ToggleRLY2%, LoopX&, ToggleFunction%, BuzzerStatus%, PlotX%, PreviousPlotY%, DSELogo%
Global TempOffset%, LDROffset%, AN1Offset%, An2Offset%, TempCal%, LDRCal%, AN1Cal%, An2Cal%, ToggleDSELogo%
Global DecimalOutputValue%, BitValTable%(10), Bit8ToPort%, Bit9ToPort%, PortDecimalData%, IntBuffer%
Global IOLogicInputDecimalVal%, IOLogicOutputDecimalVal%, ListNumber%, UpdateInterval%, ViewSplashTime%
Global HexLen%, HexToDecimalValue%, LogRow%, LogCol%, LoopZ&, AddSpaces%, AlarmDate%(10), AlarmTime%(10)
Global CurrentStatus$, LastNum$, HexValue$, LogFileName$, StrBuffer$, PreviousTempSample$
Global Buffer$, TempDegrees$(1024), VCCTable$(1024), VCCTable2$(1024), SpacesToAdd$
Global Relay2StartTime$(2), Relay2StartDate$(2), Relay2StopTime$(2), Relay2StopDate$(2)
Global Relay1StartTime$(2), Relay1StartDate$(2), Relay1StopTime$(2), Relay1StopDate$(2)
Global DegreesCelsius!, Voltage!, IShunt!, LDRVCC!, LDRResistance!, PreviousLightVal!, Exponent!
Global TimerA!, TimerB!, NoDataTimeOut!, AnalogBuffer%, Lastbit!, TimerError&, LogTimerLoop&, LogTimerCount&
Global AutoLogTimerLoop&, AutoLogTimerCount&, PlotTimerLoop&, PlotTimerCount&
Global Temperature$, VCC1$, VCC2$, Light$, InputDecimalData$

Global OkToPlot                As Boolean
Global FadeOutDSE              As Boolean
Global OkToLog                 As Boolean
Global IOLogicInputBitSet(10)  As Boolean
Global IOLogicOutputBitSet(10) As Boolean
Global Connected               As Boolean
Global RequestToSend10BitData  As Boolean
Global StartSTR                As Boolean
Global ENDSTR                  As Boolean
Global RequestToToggleRLY1     As Boolean
Global RequestToToggleRLY2     As Boolean
Global RequestToSoundBuzzer    As Boolean
Global BitSet(10)              As Boolean

Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Sub HexConversion()
   On Error Resume Next
'null value?, bail out
   If HexValue = "" Then Exit Sub
'Convert hex value to decimal
   HexToDecimalValue = 0
   HexLen = 0
   LastNum = ""
   Exponent = 0
   Lastbit = 0
   HexValue = UCase(HexValue)
   HexLen = Len(HexValue)
'loop until value is read / converted
   Do
     LastNum = Mid(HexValue, HexLen, 1)
     If LastNum = "A" Then
        LastNum = "10"
        ElseIf LastNum = "B" Then
               LastNum = "11"
        ElseIf LastNum = "C" Then
               LastNum = "12"
        ElseIf LastNum = "D" Then
               LastNum = "13"
        ElseIf LastNum = "E" Then
               LastNum = "14"
        ElseIf LastNum = "F" Then
               LastNum = "15"
     End If
     If Len(LastNum) = 1 Then
        Lastbit = LastNum * 16 ^ Exponent
        ElseIf Len(LastNum) = 2 Then
               Lastbit = LastNum * 16 ^ Exponent
     End If
                  
     HexToDecimalValue = Lastbit + HexToDecimalValue
     Exponent = Exponent + 1
     HexLen = HexLen - 1
   Loop Until HexLen = 0
End Sub

Public Sub Delay100mS()
   TimerError = 0
10 TimerA = Timer
20 TimerB = Timer
   TimerError = TimerError + 1
   DoEvents
'reset if stuck
   If TimerError > 100000 Then GoTo 10
'inc time diff
   If TimerB - TimerA < 0.1 Then GoTo 20
End Sub

Public Sub ClosedLoopControlForTemp()
'------------------------------------
'----------- Using relay 1 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay1ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(0).Text = "Temp" And _
   GUI.Relay1ClosedLoopControlVal(0).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch on if Greater than condition is true
   If GUI.Relay1ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(1).Text = "Temp" And _
   GUI.Relay1ClosedLoopControlVal(1).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay1ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(2).Text = "Temp" And _
   GUI.Relay1ClosedLoopControlVal(2).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'Switch off if Greater than condition is true
   If GUI.Relay1ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(3).Text = "Temp" And _
   GUI.Relay1ClosedLoopControlVal(3).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'------------------------------------
'----------- Using relay 2 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay2ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(0).Text = "Temp" And _
   GUI.Relay2ClosedLoopControlVal(0).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch on if Greater than condition is true
   If GUI.Relay2ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(1).Text = "Temp" And _
   GUI.Relay2ClosedLoopControlVal(1).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay2ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(2).Text = "Temp" And _
   GUI.Relay2ClosedLoopControlVal(2).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
'Switch off if Greater than condition is true
   If GUI.Relay2ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(3).Text = "Temp" And _
   GUI.Relay2ClosedLoopControlVal(3).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
End Sub

Public Sub ClosedLoopControlForLDR()
'------------------------------------
'----------- Using relay 1 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay1ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(0).Text = "LDR" And _
   GUI.Relay1ClosedLoopControlVal(0).Text > "" Then
      If LDRResistance < Val(Trim(GUI.Relay1ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay1ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(1).Text = "LDR" And _
   GUI.Relay1ClosedLoopControlVal(1).Text > "" Then
      If LDRResistance > Val(Trim(GUI.Relay1ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay1ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(2).Text = "LDR" And _
   GUI.Relay1ClosedLoopControlVal(2).Text > "" Then
      If LDRResistance < Val(Trim(GUI.Relay1ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay1ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(3).Text = "LDR" And _
   GUI.Relay1ClosedLoopControlVal(3).Text > "" Then
      If LDRResistance > Val(Trim(GUI.Relay1ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'------------------------------------
'----------- Using relay 2 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay2ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(0).Text = "LDR" And _
   GUI.Relay2ClosedLoopControlVal(0).Text > "" Then
      If LDRResistance < Val(Trim(GUI.Relay2ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay2ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(1).Text = "LDR" And _
   GUI.Relay2ClosedLoopControlVal(1).Text > "" Then
      If LDRResistance > Val(Trim(GUI.Relay2ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay2ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(2).Text = "LDR" And _
   GUI.Relay2ClosedLoopControlVal(2).Text > "" Then
      If LDRResistance < Val(Trim(GUI.Relay2ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay2ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(3).Text = "LDR" And _
   GUI.Relay2ClosedLoopControlVal(3).Text > "" Then
      If LDRResistance > Val(Trim(GUI.Relay2ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
End Sub

Public Sub ClosedLoopControlForVCC1()
'------------------------------------
'----------- Using relay 1 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay1ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(0).Text = "AN 1" And _
   GUI.Relay1ClosedLoopControlVal(0).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay1ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(1).Text = "AN 1" And _
   GUI.Relay1ClosedLoopControlVal(1).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay1ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(2).Text = "AN 1" And _
   GUI.Relay1ClosedLoopControlVal(2).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay1ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(3).Text = "AN 1" And _
   GUI.Relay1ClosedLoopControlVal(3).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'------------------------------------
'----------- Using relay 2 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay2ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(0).Text = "AN 1" And _
   GUI.Relay2ClosedLoopControlVal(0).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay2ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(1).Text = "AN 1" And _
   GUI.Relay2ClosedLoopControlVal(1).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay2ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(2).Text = "AN 1" And _
   GUI.Relay2ClosedLoopControlVal(2).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay2ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(3).Text = "AN 1" And _
   GUI.Relay2ClosedLoopControlVal(3).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
End Sub

Public Sub ClosedLoopControlForVCC2()
'------------------------------------
'----------- Using relay 1 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay1ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(0).Text = "AN 2" And _
   GUI.Relay1ClosedLoopControlVal(0).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay1ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(1).Text = "AN 2" And _
   GUI.Relay1ClosedLoopControlVal(1).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay1ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(2).Text = "AN 2" And _
   GUI.Relay1ClosedLoopControlVal(2).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay1ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(3).Text = "AN 2" And _
   GUI.Relay1ClosedLoopControlVal(3).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'------------------------------------
'----------- Using relay 2 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay2ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(0).Text = "AN 2" And _
   GUI.Relay2ClosedLoopControlVal(0).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay2ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(1).Text = "AN 2" And _
   GUI.Relay2ClosedLoopControlVal(1).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay2ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(2).Text = "AN 2" And _
   GUI.Relay2ClosedLoopControlVal(2).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay2ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(3).Text = "AN 2" And _
   GUI.Relay2ClosedLoopControlVal(3).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
End Sub

Public Sub ClosedLoopControlForInput()
'------------------------------------
'----------- Using relay 1 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay1ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(0).Text = "Input" And _
   GUI.Relay1ClosedLoopControlVal(0).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay1ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(1).Text = "Input" And _
   GUI.Relay1ClosedLoopControlVal(1).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay1ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay1ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(2).Text = "Input" And _
   GUI.Relay1ClosedLoopControlVal(2).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(GUI.Relay1ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay1ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay1ClosedLoopControlVariable(3).Text = "Input" And _
   GUI.Relay1ClosedLoopControlVal(3).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(GUI.Relay1ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay1OFF
      End If
   End If
'------------------------------------
'----------- Using relay 2 ----------
'------------------------------------
'Switch on if less than condition is true
   If GUI.Relay2ClosedLoopControlOnIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(0).Text = "Input" And _
   GUI.Relay2ClosedLoopControlVal(0).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(0).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch on if greater than condition is true
   If GUI.Relay2ClosedLoopControlOnIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(1).Text = "Input" And _
   GUI.Relay2ClosedLoopControlVal(1).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(1).Text)) Then
         Call SwitchRelay2ON
      End If
   End If
'Switch off if less than condition is true
   If GUI.Relay2ClosedLoopControlOffIfLessThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(2).Text = "Input" And _
   GUI.Relay2ClosedLoopControlVal(2).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(GUI.Relay2ClosedLoopControlVal(2).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
'Switch off if greater than condition is true
   If GUI.Relay2ClosedLoopControlOffIfGreaterThan.Value = 1 And GUI.Relay2ClosedLoopControlVariable(3).Text = "Input" And _
   GUI.Relay2ClosedLoopControlVal(3).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(GUI.Relay2ClosedLoopControlVal(3).Text)) Then
         Call SwitchRelay2OFF
      End If
   End If
End Sub

Public Sub LoggingProc()
'ON box ticked?
   If DataLogging.EnableLog.Value <> 1 Then Exit Sub
'Clear log after 2048 samples have taken place
   If LogRow >= 2047 Then
      If DataLogging.AutoClearLog.Value = 1 Then
         Call ClearLogProc
         Exit Sub
      End If
      DataLogging.ShowLogFull.Enabled = True
      Exit Sub
   End If
'Increment cell row by 1
   LogRow = LogRow + 1
   DataLogging.MSFlexGrid1.Row = LogRow
'Log temperature set?
   If DataLogging.LogVariable.Text = "Temp" Then
      DataLogging.MSFlexGrid1.Col = 0
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 0) = "Temperature"
      DataLogging.MSFlexGrid1.Col = 1
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 1) = "" + Trim(TempDegrees(Val(Temperature)))
   End If
'Log LDR set?
   If DataLogging.LogVariable.Text = "LDR" Then
      DataLogging.MSFlexGrid1.Col = 0
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 0) = "LDR Resistance"
      DataLogging.MSFlexGrid1.Col = 1
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 1) = Str(LDRResistance) + " Ohms"
   End If
'Log AN1 set?
   If DataLogging.LogVariable.Text = "AN 1" Then
      DataLogging.MSFlexGrid1.Col = 0
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 0) = "Analog Channel 1"
      DataLogging.MSFlexGrid1.Col = 1
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 1) = Format(Val(VCCTable(Val(VCC1))), "0.00") + " VDC"
   End If
'Log AN2 set?
   If DataLogging.LogVariable.Text = "AN 2" Then
      DataLogging.MSFlexGrid1.Col = 0
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 0) = "Analog Channel 2"
      DataLogging.MSFlexGrid1.Col = 1
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 1) = Format(Val(VCCTable2(Val(VCC2))), "0.00") + " VDC"
   End If
'Log 10 BIT input set?
   If DataLogging.LogVariable.Text = "Input" Then
      DataLogging.MSFlexGrid1.Col = 0
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 0) = "10 BIT Input Data"
      DataLogging.MSFlexGrid1.Col = 1
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 1) = InputDecimalData + " Dec"
   End If
   If DataLogging.EnableLogDate.Value = 1 Then
      DataLogging.MSFlexGrid1.Col = 2
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 2) = Trim(Date$)
   End If
   If DataLogging.EnableLogTime.Value = 1 Then
      DataLogging.MSFlexGrid1.Col = 3
      DataLogging.MSFlexGrid1.CellAlignment = 3
      DataLogging.MSFlexGrid1.TextMatrix(LogRow, 3) = Time$
   End If
'Auto scroll data
   If LogRow > 30 Then
      DataLogging.MSFlexGrid1.TopRow = DataLogging.MSFlexGrid1.TopRow + 1
   End If
End Sub

Public Sub ClearLogProc()
   DataLogging.MSFlexGrid1.Clear
   LogRow = 0
   DataLogging.MSFlexGrid1.TopRow = 1
   DataLogging.MSFlexGrid1.CellAlignment = 0

   DataLogging.MSFlexGrid1.Col = 0
   DataLogging.MSFlexGrid1.Row = 0
   DataLogging.MSFlexGrid1.Text = "Variable Data Type"

   DataLogging.MSFlexGrid1.Col = 1
   DataLogging.MSFlexGrid1.Row = 0
   DataLogging.MSFlexGrid1.Text = "Value"

   DataLogging.MSFlexGrid1.Col = 2
   DataLogging.MSFlexGrid1.Row = 0
   DataLogging.MSFlexGrid1.Text = "Date"

   DataLogging.MSFlexGrid1.Col = 3
   DataLogging.MSFlexGrid1.Row = 0
   DataLogging.MSFlexGrid1.Text = "Time"
End Sub

Public Sub IOLogicControlProc()
   If IOLogic.EnableIOLogicControl.Value = 1 Then
      If IOLogic.LatchIOLogicOuputs.Value <> 1 Then
         PortDecimalData = 0
         Call UpdateVirtualOutputLEDS
         RequestToSend10BitData = True
      End If
      For LoopX = 0 To IOLogic.IOLogicInputData.ListCount
          StrBuffer = Mid$(IOLogic.IOLogicInputData.List(LoopX), 25, Len(IOLogic.IOLogicInputData.List(LoopX)))
          If StrBuffer = InputDecimalData Then
             PortDecimalData = Val(Mid$(IOLogic.IOLogicOutputData.List(LoopX), 18, Len(IOLogic.IOLogicOutputData.List(LoopX))))
             If IOLogic.XORIOLogic.Value = 1 Then PortDecimalData = Val(StrBuffer) Xor PortDecimalData
             If IOLogic.InvertIOLogic.Value = 1 Then PortDecimalData = (1023 - PortDecimalData)
             Call UpdateVirtualOutputLEDS
             RequestToSend10BitData = True
          End If
      Next
   End If
End Sub

Public Sub BuzzerAlertForTemp()
'------------------------------------
'------------ Condition 1 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(0).Text = "Temp" And _
   AlarmsTimers.Condition1BuzzerAlertVal(0).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(1).Text = "Temp" And _
   AlarmsTimers.Condition1BuzzerAlertVal(1).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(2).Text = "Temp" And _
   AlarmsTimers.Condition1BuzzerAlertVal(2).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(3).Text = "Temp" And _
   AlarmsTimers.Condition1BuzzerAlertVal(3).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 2 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(0).Text = "Temp" And _
   AlarmsTimers.Condition2BuzzerAlertVal(0).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(1).Text = "Temp" And _
   AlarmsTimers.Condition2BuzzerAlertVal(1).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(2).Text = "Temp" And _
   AlarmsTimers.Condition2BuzzerAlertVal(2).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(3).Text = "Temp" And _
   AlarmsTimers.Condition2BuzzerAlertVal(3).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 3 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(0).Text = "Temp" And _
   AlarmsTimers.Condition3BuzzerAlertVal(0).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(1).Text = "Temp" And _
   AlarmsTimers.Condition3BuzzerAlertVal(1).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(2).Text = "Temp" And _
   AlarmsTimers.Condition3BuzzerAlertVal(2).Text > "" Then
      If TempDegrees(Val(Temperature)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(3).Text = "Temp" And _
   AlarmsTimers.Condition3BuzzerAlertVal(3).Text > "" Then
      If TempDegrees(Val(Temperature)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
End Sub

Public Sub BuzzerAlertForLDR()
'------------------------------------
'------------ Condition 1 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(0).Text = "LDR" And _
   AlarmsTimers.Condition1BuzzerAlertVal(0).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(1).Text = "LDR" And _
   AlarmsTimers.Condition1BuzzerAlertVal(1).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(2).Text = "LDR" And _
   AlarmsTimers.Condition1BuzzerAlertVal(2).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(3).Text = "LDR" And _
   AlarmsTimers.Condition1BuzzerAlertVal(3).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 2 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(0).Text = "LDR" And _
   AlarmsTimers.Condition2BuzzerAlertVal(0).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(1).Text = "LDR" And _
   AlarmsTimers.Condition2BuzzerAlertVal(1).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(2).Text = "LDR" And _
   AlarmsTimers.Condition2BuzzerAlertVal(2).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(3).Text = "LDR" And _
   AlarmsTimers.Condition2BuzzerAlertVal(3).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 3 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(0).Text = "LDR" And _
   AlarmsTimers.Condition3BuzzerAlertVal(0).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(1).Text = "LDR" And _
   AlarmsTimers.Condition3BuzzerAlertVal(1).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(2).Text = "LDR" And _
   AlarmsTimers.Condition3BuzzerAlertVal(2).Text > "" Then
      If LDRResistance < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(3).Text = "LDR" And _
   AlarmsTimers.Condition3BuzzerAlertVal(3).Text > "" Then
      If LDRResistance > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
End Sub

Public Sub BuzzerAlertForVCC1()
'------------------------------------
'------------ Condition 1 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(0).Text = "AN 1" And _
   AlarmsTimers.Condition1BuzzerAlertVal(0).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(1).Text = "AN 1" And _
   AlarmsTimers.Condition1BuzzerAlertVal(1).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(2).Text = "AN 1" And _
   AlarmsTimers.Condition1BuzzerAlertVal(2).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(3).Text = "AN 1" And _
   AlarmsTimers.Condition1BuzzerAlertVal(3).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 2 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(0).Text = "AN 1" And _
   AlarmsTimers.Condition2BuzzerAlertVal(0).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(1).Text = "AN 1" And _
   AlarmsTimers.Condition2BuzzerAlertVal(1).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(2).Text = "AN 1" And _
   AlarmsTimers.Condition2BuzzerAlertVal(2).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(3).Text = "AN 1" And _
   AlarmsTimers.Condition2BuzzerAlertVal(3).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 3 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(0).Text = "AN 1" And _
   AlarmsTimers.Condition3BuzzerAlertVal(0).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(1).Text = "AN 1" And _
   AlarmsTimers.Condition3BuzzerAlertVal(1).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(2).Text = "AN 1" And _
   AlarmsTimers.Condition3BuzzerAlertVal(2).Text > "" Then
      If VCCTable(Val(VCC1)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(3).Text = "AN 1" And _
   AlarmsTimers.Condition3BuzzerAlertVal(3).Text > "" Then
      If VCCTable(Val(VCC1)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
End Sub

Public Sub BuzzerAlertForVCC2()
'------------------------------------
'------------ Condition 1 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(0).Text = "AN 2" And _
   AlarmsTimers.Condition1BuzzerAlertVal(0).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(1).Text = "AN 2" And _
   AlarmsTimers.Condition1BuzzerAlertVal(1).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(2).Text = "AN 2" And _
   AlarmsTimers.Condition1BuzzerAlertVal(2).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(3).Text = "AN 2" And _
   AlarmsTimers.Condition1BuzzerAlertVal(3).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 2 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(0).Text = "AN 2" And _
   AlarmsTimers.Condition2BuzzerAlertVal(0).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(1).Text = "AN 2" And _
   AlarmsTimers.Condition2BuzzerAlertVal(1).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(2).Text = "AN 2" And _
   AlarmsTimers.Condition2BuzzerAlertVal(2).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(3).Text = "AN 2" And _
   AlarmsTimers.Condition2BuzzerAlertVal(3).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 3 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(0).Text = "AN 2" And _
   AlarmsTimers.Condition3BuzzerAlertVal(0).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(1).Text = "AN 2" And _
   AlarmsTimers.Condition3BuzzerAlertVal(1).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(2).Text = "AN 2" And _
   AlarmsTimers.Condition3BuzzerAlertVal(2).Text > "" Then
      If VCCTable2(Val(VCC2)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(3).Text = "AN 2" And _
   AlarmsTimers.Condition3BuzzerAlertVal(3).Text > "" Then
      If VCCTable2(Val(VCC2)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
End Sub

Public Sub BuzzerAlertForInput()
'------------------------------------
'------------ Condition 1 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(0).Text = "Input" And _
   AlarmsTimers.Condition1BuzzerAlertVal(0).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(1).Text = "Input" And _
   AlarmsTimers.Condition1BuzzerAlertVal(1).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(2).Text = "Input" And _
   AlarmsTimers.Condition1BuzzerAlertVal(2).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition1BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition1(3).Text = "Input" And _
   AlarmsTimers.Condition1BuzzerAlertVal(3).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition1BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 2 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(0).Text = "Input" And _
   AlarmsTimers.Condition2BuzzerAlertVal(0).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(1).Text = "Input" And _
   AlarmsTimers.Condition2BuzzerAlertVal(1).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(2).Text = "Input" And _
   AlarmsTimers.Condition2BuzzerAlertVal(2).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition2BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition2(3).Text = "Input" And _
   AlarmsTimers.Condition2BuzzerAlertVal(3).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition2BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'------------------------------------
'------------ Condition 3 -----------
'------------------------------------
'Switch on if less than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(0).Text = "Input" And _
   AlarmsTimers.Condition3BuzzerAlertVal(0).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(0).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch on if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOnIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(1).Text = "Input" And _
   AlarmsTimers.Condition3BuzzerAlertVal(1).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(1).Text)) Then
         Call SwitchBuzzerON
      End If
   End If
'Switch off if less than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfLessThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(2).Text = "Input" And _
   AlarmsTimers.Condition3BuzzerAlertVal(2).Text > "" Then
      If Val(Trim(InputDecimalData)) < Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(2).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
'Switch off if Greater than condition is true
   If AlarmsTimers.Condition3BuzzerOffIfGreaterThan.Value = 1 And AlarmsTimers.BuzzerAlertVariableCondition3(3).Text = "Input" And _
   AlarmsTimers.Condition3BuzzerAlertVal(3).Text > "" Then
      If Val(Trim(InputDecimalData)) > Val(Trim(AlarmsTimers.Condition3BuzzerAlertVal(3).Text)) Then
         Call SwitchBuzzerOFF
      End If
   End If
End Sub

Public Sub SwitchBuzzerON()
   GUI.MSComm1.Output = "a" + Chr(6)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(1)
End Sub

Public Sub SwitchBuzzerOFF()
   GUI.MSComm1.Output = "a" + Chr(6)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(0)
End Sub

Public Sub SwitchRelay1OFF()
   GUI.MSComm1.Output = "a" + Chr(5)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(1) + Chr(0)
End Sub

Public Sub SwitchRelay1ON()
   GUI.MSComm1.Output = "a" + Chr(5)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(1) + Chr(1)
End Sub

Public Sub SwitchRelay2OFF()
   GUI.MSComm1.Output = "a" + Chr(5)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(2) + Chr(0)
End Sub

Public Sub SwitchRelay2ON()
   GUI.MSComm1.Output = "a" + Chr(5)
   Call GUI.UpdateStatusBar
   Call Delay100mS
   GUI.MSComm1.Output = "a" + Chr(2) + Chr(1)
End Sub

Public Sub UpdateVirtualOutputLEDS()
   On Error Resume Next
   For LoopX = 0 To 9
       If PortDecimalData And BitValTable(LoopX) Then
          BitSet(LoopX) = True
          GUI.OutputLEDOFF(LoopX).Visible = False
          GUI.OutputLEDON(LoopX).Visible = True
       Else
          BitSet(LoopX) = False
          GUI.OutputLEDON(LoopX).Visible = False
          GUI.OutputLEDOFF(LoopX).Visible = True
       End If
   Next
   GUI.ShowOutputHEX.Text = Trim(Hex(PortDecimalData))
   GUI.ShowOutputDecimal.Text = Trim(PortDecimalData)
End Sub

Public Sub UpdateVirtualInputLEDS()
   On Error Resume Next
   For LoopX = 0 To 9
       If InputDecimalData And BitValTable(LoopX) Then
          GUI.InputLEDOFF(LoopX).Visible = False
          GUI.InputLEDON(LoopX).Visible = True
       Else
          GUI.InputLEDON(LoopX).Visible = False
          GUI.InputLEDOFF(LoopX).Visible = True
       End If
   Next
   GUI.ShowInputHEX.Text = Trim(Hex(InputDecimalData))
   GUI.ShowInputDecimal.Text = Trim(InputDecimalData)
End Sub

Public Sub CheckTimers()
'---------------------------
'----- Relay 1 Event 1 -----
'---------------------------
   If AlarmsTimers.Relay1EnableEvent1 Then
      If Relay1StartTime(0) = Time$ And Relay1StartDate(0) = Date$ Or _
      AlarmsTimers.Relay1UseDate(0).Value = 0 And Relay1StartTime(0) = Time$ Then
         If AlarmsTimers.Relay1StartTimeStatus(0).Value Then
            Call SwitchRelay1ON
         Else
            Call SwitchRelay1OFF
         End If
      End If
      If Relay1StopTime(0) = Time$ And Relay1StopDate(0) = Date$ Or _
      AlarmsTimers.Relay1UseDate(0).Value = 0 And Relay1StopTime(0) = Time$ Then
         If AlarmsTimers.Relay1StopTimeStatus(0).Value Then
            Call SwitchRelay1ON
         Else
            Call SwitchRelay1OFF
         End If
      End If
   End If
'---------------------------
'----- Relay 1 Event 2 -----
'---------------------------
   If AlarmsTimers.Relay1EnableEvent1 Then
      If Relay1StartTime(1) = Time$ And Relay1StartDate(1) = Date$ Or _
      AlarmsTimers.Relay1UseDate(1).Value = 0 And Relay1StartTime(1) = Time$ Then
         If AlarmsTimers.Relay1StartTimeStatus(1).Value Then
            Call SwitchRelay1ON
         Else
            Call SwitchRelay1OFF
         End If
      End If
      If Relay1StopTime(1) = Time$ And Relay1StopDate(1) = Date$ Or _
      AlarmsTimers.Relay1UseDate(1).Value = 0 And Relay1StopTime(1) = Time$ Then
         If AlarmsTimers.Relay1StopTimeStatus(1).Value Then
            Call SwitchRelay1ON
         Else
            Call SwitchRelay1OFF
         End If
      End If
   End If
'---------------------------
'----- Relay 2 Event 1 -----
'---------------------------
   If AlarmsTimers.Relay1EnableEvent1 Then
      If Relay2StartTime(0) = Time$ And Relay2StartDate(0) = Date$ Or _
      AlarmsTimers.Relay2UseDate(0).Value = 0 And Relay2StartTime(0) = Time$ Then
         If AlarmsTimers.Relay2StartTimeStatus(0).Value Then
            Call SwitchRelay2ON
         Else
            Call SwitchRelay2OFF
         End If
      End If
      If Relay2StopTime(0) = Time$ And Relay2StopDate(0) = Date$ Or _
      AlarmsTimers.Relay2UseDate(0).Value = 0 And Relay2StopTime(0) = Time$ Then
         If AlarmsTimers.Relay2StopTimeStatus(0).Value Then
            Call SwitchRelay2ON
         Else
            Call SwitchRelay2OFF
         End If
      End If
   End If
'---------------------------
'----- Relay 2 Event 2 -----
'---------------------------
   If AlarmsTimers.Relay1EnableEvent1 Then
      If Relay2StartTime(1) = Time$ And Relay2StartDate(1) = Date$ Or _
      AlarmsTimers.Relay1UseDate(1).Value = 0 And Relay2StartTime(1) = Time$ Then
         If AlarmsTimers.Relay2StartTimeStatus(1).Value Then
            Call SwitchRelay2ON
         Else
            Call SwitchRelay2OFF
         End If
      End If
      If Relay2StopTime(1) = Time$ And Relay2StopDate(1) = Date$ Or _
      AlarmsTimers.Relay2UseDate(1).Value = 0 And Relay2StopTime(1) = Time$ Then
         If AlarmsTimers.Relay2StopTimeStatus(1).Value Then
            Call SwitchRelay2ON
         Else
            Call SwitchRelay2OFF
         End If
      End If
   End If
End Sub
